﻿using StokYonetimSistemi.DataAccess;
using StokYonetimSistemi.Entities;
using System;
using System.Linq;

namespace StokYonetimSistemi.Business
{
    public class StokManager
    {
        public void StokGirisiYap(int urunId, int miktar, decimal? birimFiyat, int kullaniciId)
        {
            using (var context = new StokYonetimDbContext())
            {
                // Veri tutarlılığını sağlamak için bir transaction başlatıyoruz.
                using (var transaction = context.Database.BeginTransaction())
                {
                    try
                    {
                        // 1. Adım: Stok Hareketini Oluştur ve Ekle
                        var stokHareketi = new StokHareketi
                        {
                            UrunId = urunId,
                            Miktar = miktar,
                            BirimFiyat = birimFiyat,
                            HareketTipi = "GIRIS",
                            Tarih = DateTime.Now,
                            KullaniciId = kullaniciId
                        };
                        context.StokHareketleri.Add(stokHareketi);

                        // 2. Adım: Ürünün Stoğunu Güncelle
                        var urun = context.Urunler.Find(urunId);
                        if (urun != null)
                        {
                            urun.StokAdedi += miktar; // Mevcut stoğun üzerine ekle
                        }
                        else
                        {
                            throw new Exception("Stok girişi yapılacak ürün bulunamadı!");
                        }

                        // Tüm değişiklikleri veritabanına kaydet
                        context.SaveChanges();

                        // Her şey yolunda gittiyse, transaction'ı onayla (Commit)
                        transaction.Commit();
                    }
                    catch (Exception)
                    {
                        // Herhangi bir adımda hata olursa, yapılan tüm işlemleri geri al (Rollback)
                        transaction.Rollback();
                        // Hatayı üst katmana fırlat ki kullanıcı bilgilendirilsin.
                        throw;
                    }
                }
            }
        }
                    // BU YENİ METODU MEVCUT SINIFIN İÇİNE EKLEYİN
        public void StokCikisiYap(int urunId, int miktar, int kullaniciId)
        {
            using (var context = new StokYonetimDbContext())
            {
                using (var transaction = context.Database.BeginTransaction())
                {
                    try
                    {
                        // 1. Adım: Ürünün mevcut stoğunu kontrol et
                        var urun = context.Urunler.Find(urunId);
                        if (urun == null)
                        {
                            throw new Exception("Stok çıkışı yapılacak ürün bulunamadı!");
                        }

                        // EN ÖNEMLİ İŞ KURALI: Stok eksiye düşemez!
                        if (urun.StokAdedi < miktar)
                        {
                            throw new Exception($"Yetersiz stok! Ürünün mevcut stoğu: {urun.StokAdedi}. Çıkılmak istenen miktar: {miktar}.");
                        }

                        // 2. Adım: Ürünün Stoğunu Azalt
                        urun.StokAdedi -= miktar;

                        // 3. Adım: Stok Hareketini Oluştur ve Ekle
                        var stokHareketi = new StokHareketi
                        {
                            UrunId = urunId,
                            Miktar = miktar,
                            BirimFiyat = null, // Satış fiyatı farklı bir modülde yönetilebilir, burada sadece stok düşüyoruz.
                            HareketTipi = "CIKIS",
                            Tarih = DateTime.Now,
                            KullaniciId = kullaniciId
                        };
                        context.StokHareketleri.Add(stokHareketi);

                        // Tüm değişiklikleri veritabanına kaydet
                        context.SaveChanges();

                        // Her şey yolunda gittiyse, transaction'ı onayla
                        transaction.Commit();
                    }
                    catch (Exception)
                    {
                        // Hata olursa, yapılan tüm işlemleri geri al
                        transaction.Rollback();
                        throw;
                    }
                }
            }
        }
    }
}